<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */
?><!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyeleven' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link href='http://fonts.googleapis.com/css?family=PT+Serif:400,700italic,700,400italic' rel='stylesheet' type='text/css'>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.tools.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/commonvalidation.js"  type="text/javascript"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.tinyscrollbar.min.js"  type="text/javascript"></script>
<script type="text/javascript">
	$(document).ready(function(){
		$('#scrollbar1').tinyscrollbar();	
	});
</script>

<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
<?php if(is_home()){ ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/slider/css/tabs-slideshow.css" type="text/css" media="screen" />
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/slider/jscripts/jquery.tools.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/slider/jscripts/scroll.js" type="text/javascript"></script>
<script>
/*jQuery(function() {

jQuery(".slidetabs").tabs(".images > div", {

	// enable "cross-fading" effect
	effect: 'fade',
	fadeOutSpeed: 1500,
	fadeInSpeed: 1500,
	interval:8000,
	// start from the beginning after the last tab
	rotate: true

// use the slideshow plugin. It accepts its own configuration
}).slideshow();
});*/

$(function() {
$(".slidetabs").tabs(".images > div", {
	// enable "cross-fading" effect
	effect: 'fade',
	//fadeOutSpeed: "slow",
	fadeInSpeed: 1500,
    fadeOutSpeed: 1500,	
	// start from the beginning after the last tab
	rotate: true
// use the slideshow plugin. It accepts its own configuration
}).slideshow({interval: 5000,fadeOutSpeed: "slow"});
$(".slidetabs").data("slideshow").play();

});


jQuery().ready(function() {
		jQuery(".slidetabs").data("slideshow").play();
	});
	

</script>
<?php } ?>
</head>

<body class="<?php echo (!is_page('219'))?"home_body":"inner_body" ?>" >
<div id="page" class="hfeed"> <?php if (is_page('219')){ ?> <div id="pageinner" class="hfeed"> 
    <?php } ?>
	<div id="header"><div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php bloginfo('template_directory'); ?>/images/oapil-logo .png" alt="Oman aluminium processing industries LLC " title="Oman aluminium processing industries LLC"/></a></div>
	
	
	<div style="width:40%;float:right;margin:12px 11px 0px 0px;font-family:Arial, Helvetica, sans-serif;font-weight:normal;color#808080;">
	
		<span style="width:76%;float:right;margin:20px 0px 0px 74px;line-height:18px;font-size:14px;">Oman Aluminium Processing Industries LLC</span><br /><span style="width:76%;float:right;line-height:18px;font-size:12px;">Sohar industrial Estate, Phase 6, Sohar, Oman</span><br /><span style="width:76%;float:right;line-height:18px;font-size:10px;">Plot 606, PO Box 324, PC 322</span>
		 <div style="float:right;width:100px; text-align:center;">
  	<table cellpadding="2px" style="float:left;">
      <tr>
      	<td class="followUS"></td>
        <td class="SocialSITE"><a href="https://remote.oapil.com/owa" title="Webmail" target="_blank" style="text-decoration:none;"/><img src="http://oapil.com/test/wp-content/uploads/2012/07/icon-webmail.png" title="webmail" alt="webmail"/></a></td>
        <td class="followUS" style="padding:7px;"><a href="https://remote.oapil.com/owa" title="Webmail" target="_blank" style="text-decoration:none;"/></a></td>
      </tr>
    </table>
  </div>
  <div class="socialNET">
    <table cellpadding="2px" style="float:right;padding-right:3px;">
      <tr>
      	<td class="followUS"><span style="color:#000000;"></span></td>
        <td class="followUS"></td>
        <td class="SocialSITE"><a href="http://www.linkedin.com/pub/oman-aluminium/53/631/a96" title="LinkedIn" target="_blank" style="text-decoration:none;"/><img src="wp-content/uploads/2011/07/linkden.png" title="LinkedIn" alt="LinkedIn"/></a></td>
        <td  class="SocialSITE"><a href="http://www.facebook.com/pages/Oapil/345333635538712" title="Facebook" target="_blank" style="text-decoration:none;"/><img src="wp-content/uploads/2011/07/facebook.png" title="Facebook" alt="Facebook"/></a></td>
      </tr>
    </table>
  </div>

		<!--<form method="get" id="searchform" action=<?php echo esc_url( home_url( '/' ) ); ?>">
			<label for="s" class="assistive-text">Search</label>
			<input type="text" class="field" name="s" id="s" placeholder="Search" style="float:right;margin:0px 30px 0px 0px;"/>
			<input type="submit" class="submit" name="submit" id="searchsubmit" value="Search" />
		</form>-->
		
	</div>
	
	
		<!--<hgroup>
				<h1 id="site-title"><span><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></span></h1>
				<h2 id="site-description"><?php bloginfo( 'description' ); ?></h2>
			</hgroup>-->
            
     
  <!-- slider starts -->
  <?php
	if(is_home()){
		echo '<div class="slider">';
?>
<div class="SlideShowCont">
            <!-- container for the slides -->
            <div class="images">
                <!-- first slide -->
                <div>
                  <img src="<?php echo esc_url( home_url( '/' ) ); ?>/wp-content/themes/oapil/images/gallery_pic_1.jpg" alt="" width="918" height="324" />
                </div>
               <!-- second slide -->
                <div>

                  <img src="<?php echo esc_url( home_url( '/' ) ); ?>/wp-content/themes/oapil/images/gallery_pic_2.jpg" alt="" width="918" height="324"/>
                </div>
                <!-- third slide -->
                <div>
                  <img src="<?php echo esc_url( home_url( '/' ) ); ?>/wp-content/themes/oapil/images/gallery_pic_3.jpg" alt="" width="918" height="324" /> 
                </div>
                  <div>
                  <img src="<?php echo esc_url( home_url( '/' ) ); ?>/wp-content/themes/oapil/images/gallery_pic_4.jpg" alt="" width="918" height="324" /> 
                </div>
                <div>
                  <img src="<?php echo esc_url( home_url( '/' ) ); ?>/wp-content/themes/oapil/images/gallery_pic_5.jpg" alt="" width="918" height="324" /> 
                </div>
            </div>
            <!-- the tabs -->
            <div class="slidetabs">

                <ul>    
                    <li><a href="#"> </a></li>
                    <li><a href="#"> </a></li>
                    <li><a href="#"> </a></li>
                     <li><a href="#"> </a></li>
                      <li><a href="#"> </a></li>
              </ul>
            </div>
</div>
<div style="clear:both"></div>
<?php	}else{
		echo '<div class="sliderinner">';
		if(is_page('16')){
			echo '<img src="'.get_template_directory_uri().'/images/business_header.jpg" />';
		}else if(is_page('63')){
			echo '<img src="'.get_template_directory_uri().'/images/business_header.jpg" style="z-index:999;"/>';
		}
		else if(is_page('58')){
			echo '<img src="'.get_template_directory_uri().'/images/Qhse_business_header.jpg" />';
		}else if(is_page('60')){
			echo '<img src="'.get_template_directory_uri().'/images/stack_business_header.jpg" />';
		}else{
			echo '<img src="'.get_template_directory_uri().'/images/default_header.jpg" />';
		}		
	} 
?>
   
   <!-- slider ends -->
  
  </div>
			
	<!--		<?php
				// Check to see if the header image has been removed
				$header_image = get_header_image();
				if ( ! empty( $header_image ) ) :
			?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
				<?php
					// The header image
					// Check if this is a post or page, if it has a thumbnail, and if it's a big one
					if ( is_singular() &&
							has_post_thumbnail( $post->ID ) &&
							( /* $src, $width, $height */ $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), array( HEADER_IMAGE_WIDTH, HEADER_IMAGE_WIDTH ) ) ) &&
							$image[1] >= HEADER_IMAGE_WIDTH ) :
						// Houston, we have a new header image!
						echo get_the_post_thumbnail( $post->ID, 'post-thumbnail' );
					else : ?>
					<img src="<?php header_image(); ?>" width="<?php echo HEADER_IMAGE_WIDTH; ?>" height="<?php echo HEADER_IMAGE_HEIGHT; ?>" alt="" />
				<?php endif; // end check for featured image or standard header ?>
			</a>
			<?php endif; // end check for removed header image ?>

			<?php
				// Has the text been hidden?
				if ( 'blank' == get_header_textcolor() ) :
			?>
				<div class="only-search<?php if ( ! empty( $header_image ) ) : ?> with-image<?php endif; ?>">
				<?php get_search_form(); ?>
				</div>
			<?php
				else :
			?>
				<?php get_search_form(); ?>
			<?php endif; ?>-->
			<div id="access" role="navigation">
				<h3 class="assistive-text"><?php _e( 'Main menu', 'twentyeleven' ); ?></h3>
				<?php /*  Allow screen readers / text browsers to skip the navigation menu and get right to the good stuff. */ ?>
				<div class="skip-link"><a class="assistive-text" href="#content" title="<?php esc_attr_e( 'Skip to primary content', 'twentyeleven' ); ?>"><?php _e( 'Skip to primary content', 'twentyeleven' ); ?></a></div>
				<div class="skip-link"><a class="assistive-text" href="#secondary" title="<?php esc_attr_e( 'Skip to secondary content', 'twentyeleven' ); ?>"><?php _e( 'Skip to secondary content', 'twentyeleven' ); ?></a></div>
				<?php /* Our navigation menu.  If one isn't filled out, wp_nav_menu falls back to wp_page_menu. The menu assiged to the primary position is the one used. If none is assigned, the menu with the lowest ID is used. */ ?>
				<?php if(is_home()){
							wp_nav_menu( array( 'theme_location' => 'primary','container_class'=>'home_menu_cont' ) ); 
					}else{
							wp_nav_menu( array( 'theme_location' => 'primary','container_class'=>'inner_menu_cont' ));
					}?>
    
			</div><!-- #access -->
	</div><!-- #branding -->


	<div id="main">