<?php

/*
Plugin Name: Random image gallery with light box
Plugin URI: http://www.gopiplus.com/work/2010/07/18/random-image-gallery-with-light-box/
Description: This plug-in which allows you to simply and easily show random image anywhere in your template files or using widgets with onclick light box effect.  
Author: Gopi.R
Version: 5.0
Author URI: http://www.gopiplus.com/work/2010/07/18/random-image-gallery-with-light-box/
Donate link: http://www.gopiplus.com/work/2010/07/18/random-image-gallery-with-light-box/
*/

/**
 *     Random image gallery with light box
 *     Copyright (C) 2012  www.gopiplus.com
 *     http://www.gopiplus.com/work/2010/07/18/random-image-gallery-with-light-box/
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

function rigwlb_show() 
{
	$rigwlb_siteurl = get_option('siteurl') . "/wp-content/plugins/random-image-gallery-with-light-box/";
	include("select-random-image.php");
	?>
	<script type="text/javascript">
	$(document).ready(
		function()
		{
			$.ImageBox.init(
				{
					loaderSRC: '<?php echo get_option('siteurl'); ?>/wp-content/plugins/random-image-gallery-with-light-box/images/loading.gif',
					closeHTML: '<img src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/random-image-gallery-with-light-box/images/closelabel.gif" />'
				}
			);
		}
	);
	</script>
	<?php
}

function rigwlb_install() 
{
	add_option('rigwlb_title', "Slideshow Lightbox");
	add_option('rigwlb_width', "180");
	add_option('rigwlb_dir', "wp-content/plugins/random-image-gallery-with-light-box/random-gallery/");
	add_option('rigwlb_title_yes', "YES");
}

function rigwlb_widget($args) 
{
	extract($args);
	if(get_option('rigwlb_title_yes') == "YES") 
	{
		echo $before_widget . $before_title;
		echo get_option('rigwlb_title');
		echo $after_title;
	}
	rigwlb_show();
	if(get_option('rigwlb_title_yes') == "YES") 
	{
		echo $after_widget;
	}
}

function rigwlb_admin_option() 
{
	
	echo "<div class='wrap'>";
	echo "<h2>"; 
	echo "Random image gallery with light box (R I G W L B)";
	echo "</h2>";
    
	$rigwlb_title = get_option('rigwlb_title');
	$rigwlb_width = get_option('rigwlb_width');
	$rigwlb_dir = get_option('rigwlb_dir');
	$rigwlb_title_yes = get_option('rigwlb_title_yes');
	
	if (@$_POST['rigwlb_submit']) 
	{
		$rigwlb_title = stripslashes($_POST['rigwlb_title']);
		$rigwlb_width = stripslashes($_POST['rigwlb_width']);
		$rigwlb_dir = stripslashes($_POST['rigwlb_dir']);
		$rigwlb_title_yes = stripslashes($_POST['rigwlb_title_yes']);
		
		update_option('rigwlb_title', $rigwlb_title );
		update_option('rigwlb_width', $rigwlb_width );
		update_option('rigwlb_dir', $rigwlb_dir );
		update_option('rigwlb_title_yes', $rigwlb_title_yes );
	}
	?>
	<form name="form_hsa" method="post" action="">
	<table width="100%" border="0" cellspacing="0" cellpadding="3"><tr><td align="left">
	<?php
	echo '<p>Title:<br><input  style="width: 450px;" maxlength="200" type="text" value="';
	echo $rigwlb_title . '" name="rigwlb_title" id="rigwlb_title" /></p>';
	echo '<p>Width:<br><input  style="width: 250px;" maxlength="3" type="text" value="';
	echo $rigwlb_width . '" name="rigwlb_width" id="rigwlb_width" /> (Only Number)</p>';
	echo '<p>Display Sidebar Title:<br><input maxlength="3" style="width: 250px;" type="text" value="';
	echo $rigwlb_title_yes . '" name="rigwlb_title_yes" id="rigwlb_title_yes" /> (YES/NO)</p>';
	echo '<p>Image directory:<br><input  style="width: 550px;" type="text" value="';
	echo $rigwlb_dir . '" name="rigwlb_dir" id="rigwlb_dir" /></p>';
	echo '<p>Default Image directory:<br />wp-content/plugins/random-image-gallery-with-light-box/random-gallery/<br />';
	echo 'Dont upload your original images into this defult folder, instead you change this default path to original image path.</p>';
	echo '<input name="rigwlb_submit" id="rigwlb_submit" class="button-primary" value="Submit" type="submit" />';
	?>
	</td><td align="center" valign="middle">  </td></tr></table>
	</form>
	<br /><strong>Drag and drop the widget</strong><br />
	<br />Go to widget menu and drag and drop the "R I G W L B" widget to your sidebar location.<br />
    <br /><strong>Paste the below php code to your php file</strong><br /><br />
    <div style="padding-top:7px;padding-bottom:7px;">
    <code style="padding:7px;">
    &lt;?php if (function_exists (rigwlb_show)) rigwlb_show(); ?&gt;
    </code></div>
	<br /><br />Note: Check official website for more information <a target="_blank" href='http://www.gopiplus.com/work/2010/07/18/random-image-gallery-with-light-box/'>Click here</a><br />
	<?php
	echo "</div>";
}

function rigwlb_control()
{
	echo '<p>Random image gallery with light box.<br> To change the setting goto R I G W L B link under setting menu.';
	echo ' <a href="options-general.php?page=random-image-gallery-with-light-box/random-image-gallery-with-light-box.php">';
	echo 'click here</a></p>';
}

function rigwlb_widget_init() 
{
	if(function_exists('wp_register_sidebar_widget')) 	
	{
		wp_register_sidebar_widget('rigwlb', 'R I G W L B', 'rigwlb_widget');
	}
	
	if(function_exists('wp_register_widget_control')) 	
	{
		wp_register_widget_control('rigwlb', array('R I G W L B', 'widgets'), 'rigwlb_control');
	} 
}

function rigwlb_deactivation() 
{
	delete_option('rigwlb_title');
	delete_option('rigwlb_width');
	delete_option('rigwlb_dir');
	delete_option('rigwlb_title_yes');
}

function rigwlb_add_to_menu() 
{
	add_options_page('Random image gallery with light box - R I G W L B', 'R I G W L B', 'manage_options', __FILE__, 'rigwlb_admin_option' );
}

if (is_admin()) 
{
	add_action('admin_menu', 'rigwlb_add_to_menu');
}

function rigwfz_add_javascript_files() 
{
	if (!is_admin())
	{
		wp_enqueue_script( 'imagebox_jquery', get_option('siteurl').'/wp-content/plugins/random-image-gallery-with-light-box/inc/jquery.js');
		wp_enqueue_script( 'iutil', get_option('siteurl').'/wp-content/plugins/random-image-gallery-with-light-box/inc/iutil.js');
		wp_enqueue_script( 'imagebox_new', get_option('siteurl').'/wp-content/plugins/random-image-gallery-with-light-box/inc/imagebox_new.js');
		wp_enqueue_style( 'imagebox_new', get_option('siteurl').'/wp-content/plugins/random-image-gallery-with-light-box/inc/imagebox_new.css', '' , '5.0' , 'screen');
	}	
}

add_action('init', 'rigwfz_add_javascript_files');

add_action("plugins_loaded", "rigwlb_widget_init");
register_activation_hook(__FILE__, 'rigwlb_install');
register_deactivation_hook(__FILE__, 'rigwlb_deactivation');
add_action('init', 'rigwlb_widget_init');
?>
